const request = require('request');

class MsgSyncWhatsappAPI {
    constructor(instance_id, token) {
        this.instance_id = instance_id;
        this.token = token;
        this.url = "https://msgsync.net/api/v1";
    }

    __add_headers(headers = {}) {
        headers["Instance-id"] = this.instance_id;
        headers["Token"] = this.token;
        headers["User-Agent"] = "MsgSync API Browser";
        headers["Content-Type"] = "application/x-www-form-urlencoded";
        return headers;
    }

    __execute_request(method, path, params, data, json) {
        const url = `${this.url}${path}`;
        const headers = this.__add_headers();
        const options = { method, url, qs: params, body: data, json, headers };
        return new Promise((resolve, reject) => {
            request(options, (error, response, body) => {
                if (error) {
                    reject(error);
                } else {
                    resolve(response);
                }
            });
        });
    }

    async get_client_class_info() {
        const path = "/get_client_class_info/";
        return await this.__execute_request("POST", path);
    }

    async accept_invite(invite_code) {
        const path = "/accept_invite";
        const data = { invite_code };
        return await this.__execute_request("POST", path, null, data);
    }

    async archive_chat(chat_id) {
        const path = "/archive_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async create_group() {
        const path = "/create_group/";
        return await this.__execute_request("POST", path);
    }

    async get_blocked_contacts() {
        const path = "/get_blocked_contacts/";
        return await this.__execute_request("POST", path);
    }

    async get_chat_by_id(chat_id) {
        const path = "/get_chat_by_id/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_chat_labels(chat_id) {
        const path = "/get_chat_labels/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_chats() {
        const path = "/get_chats/";
        return await this.__execute_request("POST", path);
    }

    async get_groups() {
        const path = "/get_groups/";
        return await this.__execute_request("POST", path);
    }

    async get_chats_by_label_id(label_id) {
        const path = "/get_chats_by_label_id/";
        const data = { label_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_common_groups(contact_id) {
        const path = "/get_common_groups/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_contact_by_id(contact_id) {
        const path = "/get_contact_by_id/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_contacts() {
        const path = "/get_contacts/";
        return await this.__execute_request("POST", path);
    }

    async get_invite_info(invite_code) {
        const path = "/get_invite_info/";
        const data = { inviteCode: invite_code };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_label_by_id(label_id) {
        const path = "/get_label_by_id/";
        const data = { label_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_labels() {
        const path = "/get_labels/";
        return await this.__execute_request("POST", path);
    }

    async get_number_id(number) {
        const path = "/get_number_id/";
        const data = { number };
        return await this.__execute_request("POST", path, null, data);
    }

    async is_registered_user(number) {
        const path = "/is_registered_user/";
        const data = { number };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_state() {
        const path = "/get_state/";
        return await this.__execute_request("POST", path);
    }

    async mark_chat_unread(chat_id) {
        const path = "/mark_chat_unread/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async mute_chat(chat_id, unmute_date) {
        const path = "/mute_chat/";
        const data = { chat_id, unmute_date };
        return await this.__execute_request("POST", path, null, data);
    }

    async pin_chat(chat_id) {
        const path = "/pin_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async search_messages(query, options = {}) {
        const path = "/search_messages/";
        const data = { query, options };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_text_message(chat_id, message) {
        const path = "/send_text_message/";
        const data = { chat_id, message };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_media_message(chat_id, mimetype, data, filename) {
        const path = "/send_media_message/";
        const postData = { chat_id, mimetype, data, filename };
        return await this.__execute_request("POST", path, null, postData);
    }

    async send_media_message_from_url(chat_id, url) {
        const path = "/send_media_message_from_url/";
        const data = { chat_id, url };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_location_message(chat_id, latitude, longitude, description = '') {
        const path = "/send_location_message/";
        const data = { chat_id, latitude, longitude, description };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_buttons_message(chat_id, body, buttons, title, footer) {
        const path = "/send_buttons_message/";
        const data = { chat_id, body, buttons, title, footer };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_list_message(chat_id, body, button_text, sections, title, footer) {
        const path = "/send_list_message/";
        const data = { chat_id, body, buttonText: button_text, sections, title, footer };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_contact_message(chat_id, contact_id) {
        const path = "/send_contact_message/";
        const data = { chat_id, contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_presence_available() {
        const path = "/send_presence_available/";
        return await this.__execute_request("POST", path);
    }

    async send_presence_unavailable() {
        const path = "/send_presence_unavailable/";
        return await this.__execute_request("POST", path);
    }

    async send_seen(chat_id) {
        const path = "/send_seen/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_display_name(display_name) {
        const path = "/set_display_name/";
        const data = { displayName: display_name };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_profile_picture(picture_mimetype, picture_data) {
        const path = "/set_profile_picture/";
        const data = { pictureMimetype: picture_mimetype, pictureData: picture_data };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_status(status) {
        const path = "/set_status/";
        const data = { status };
        return await this.__execute_request("POST", path, null, data);
    }

    async unarchive_chat(chat_id) {
        const path = "/unarchive_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async unmute_chat(chat_id) {
        const path = "/unmute_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async unpin_chat(chat_id) {
        const path = "/unpin_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_wweb_version() {
        const path = "/get_wweb_version/";
        return await this.__execute_request("POST", path);
    }

    async get_class_chat_info(chat_id) {
        const path = "/get_class_chat_info/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async clear_messages(chat_id) {
        const path = "/clear_messages/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async clear_state(chat_id) {
        const path = "/clear_state/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async delete_chat(chat_id) {
        const path = "/delete_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async fetch_messages(chat_id, search_options = {}) {
        const path = "/fetch_messages";
        const data = { chat_id, searchOptions: search_options };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_contact(chat_id) {
        const path = "/get_contact/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_state_recording(chat_id) {
        const path = "/send_state_recording/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async send_state_typing(chat_id) {
        const path = "/send_state_typing/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_group_chat_class_info(chat_id) {
        const path = "/get_group_chat_class_info/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async add_participants_to_group_chat(chat_id) {
        const path = "/add_participants_to_group_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async demote_participants_in_group_chat(chat_id) {
        const path = "/demote_participants_in_group_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_group_chat_invite_code(chat_id) {
        const path = "/get_group_chat_invite_code/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async leave_group_chat(chat_id) {
        const path = "/leave_group_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async promote_participants_in_group_chat(chat_id) {
        const path = "/promote_participants_in_group_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async remove_participants_from_group_chat(chat_id) {
        const path = "/remove_participants_from_group_chat/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async revoke_group_chat_invite(chat_id) {
        const path = "/revoke_group_chat_invite/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_group_chat_description(chat_id) {
        const path = "/set_group_chat_description/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_group_chat_info_admins_only(chat_id) {
        const path = "/set_group_chat_info_admins_only/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_group_chat_messages_admins_only(chat_id) {
        const path = "/set_group_chat_messages_admins_only/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async set_group_chat_subject(chat_id) {
        const path = "/set_group_chat_subject/";
        const data = { chat_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_class_message_info(chat_id, message_id) {
        const path = "/get_class_message_info/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async delete_message(chat_id, message_id) {
        const path = "/delete_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async download_media(chat_id, message_id) {
        const path = "/download_media/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async forward_message(chat_id, message_id) {
        const path = "/forward_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_message_info(chat_id, message_id) {
        const path = "/get_message_info/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_quoted_message(chat_id, message_id) {
        const path = "/get_quoted_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async react_to_message(chat_id, message_id) {
        const path = "/react_to_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async reply_to_message(chat_id, message_id) {
        const path = "/reply_to_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async star_message(chat_id, message_id) {
        const path = "/star_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async unstar_message(chat_id, message_id) {
        const path = "/unstar_message/";
        const data = { chat_id, messageId: message_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_contact_info(contact_id) {
        const path = "/get_contact_info/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async block_contact(contact_id) {
        const path = "/block_contact/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_contact_about(contact_id) {
        const path = "/get_contact_about/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_chat_info(contact_id) {
        const path = "/get_chat_info/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async unblock_contact(contact_id) {
        const path = "/unblock_contact/";
        const data = { contact_id };
             return await this.__execute_request("POST", path, null, data);
    }

    async get_formatted_number(contact_id) {
        const path = "/get_formatted_number/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_country_code(contact_id) {
        const path = "/get_country_code/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }

    async get_profile_pic_url(contact_id) {
        const path = "/get_profile_pic_url/";
        const data = { contact_id };
        return await this.__execute_request("POST", path, null, data);
    }
}